
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Mar 06 20:41:57 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RND_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_RND_Acceptance.h"
#include "CRYS_ATP_TST_RND_Acceptance_test_vectors.h"


#include "DX_VOS_Mem.h"

#if TST_USE_RND_DATA/*In case no test vectors are selected - code disabled*/

/******** Defines **********/
/******** Enums **********/
/******** Typedefs **********/
/******** Global Data **********/
/* two global variables that contain entropy values that are used in PRNG functions,
only if these functions are compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.
The responsibility of the ATP test is to define these global variables and
to initialize them with requested by test specification values.*/
#ifdef RND_KAT_TEST_MODE_FOR_VER_21
DxUint32_t GlobalEntropy[4];
DxUint32_t GlobalFirstEntropy[2];
#endif


/***** Private function prototype ******/
/******** Public Functions **********/
/******** Private Functions **********/
/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_RND_Acceptance_No_Reset        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for Random API's 
 *  Generating different randoms in verious sizes                       
 *                                  
 * Algorithm:       
 * 1. Call the CRYS_RND_GenerateVector function to generate a random value
 * 2. Call the CRYS_RND_GenerateVector to generate a random second random value
 * 3. Compare the random numbers and verify the are different                                               
 *
 **************************/                                
CRYSError_t CRYS_ATP_TST_RND_Acceptance_No_Reset ( void )
{

    /*** TST Variables Definitions ****/
    TST_RND_TestDataStruct  TST_RND_Results = {{0},{0}};    
    DxUint16_t              TST_RNDSize;
    CRYSError_t             TST_Status=0;
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RND_Acceptance_No_Reset";

    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ATP_TST_RND_Acceptance_No_Reset Tests       ******** \n"));       
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_RNDSize = 10 ; TST_RNDSize < TST_MAX_DATA_VEC_SIZE_IN_BYTS/2  ; TST_RNDSize=TST_RNDSize+20)
    {
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Random generation - Random Size = %ld \n", TST_RNDSize));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));


        /* Generate first random value */
        /*-----------------------------*/
        TST_ATP_StartPerformanceTimer(&TST_Timer);

        TST_Status = CRYS_RND_GenerateVector(TST_RNDSize,TST_RND_Results.TST_RND_Output1);

        TST_ATP_GetPerformanceTimer(&TST_Timer);
        TST_ATP_CalcPerformance(TST_RNDSize);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RND_GenerateVector","TST_RND_Output1",TST_MasterTestName);


        /* Generate Second random value */
        /*------------------------------*/    
        TST_ATP_StartPerformanceTimer(&TST_Timer);

        TST_Status = CRYS_RND_GenerateVector(TST_RNDSize,TST_RND_Results.TST_RND_Output2);

        TST_ATP_GetPerformanceTimer(&TST_Timer);
        TST_ATP_CalcPerformance(TST_RNDSize);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RND_GenerateVector","TST_RND_Output2",TST_MasterTestName);

        
        /* Compare the Random Values */
        /*---------------------------*/     
        TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_RND_Results.TST_RND_Output1,
                                            TST_RND_Results.TST_RND_Output2 ,
                                            TST_RNDSize);
                               
        ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                    "\nTST_RND_Output1--\n",
                                    TST_RND_Results.TST_RND_Output1,
                                    TST_RNDSize);
                                    
        ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                    "\nTST_RND_Output2--\n",
                                    TST_RND_Results.TST_RND_Output2,
                                    TST_RNDSize);                                                                      
                               

    if (TST_Status == TESTPASS)
        {
        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n","TST_RND_Output1+2"));           
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - %s failed\n","DX_VOS_MemCmp"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - Wrong Error returned!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - Error returned  --- %lX \n" ,TST_Status ));               
            return TESTFAIL;
        }
        else
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"TST_massage - "));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"%s","DX_VOS_MemCmp"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Error returned correctly - Test pass \n"));                              
        }
    } /* End of TST_RNDSize loop*/
  return TST_PASS;
   
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
} /*End of test*/
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_RND_Acceptance_No_Reset        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for Random API's 
 *  Generating different randoms in various sizes   
 *  With Seed reset before any generation                   
 *                                  
 * Algorithm:       
 * 1. Call the CRYS_RND_GenerateVector function to generate a random value
 * 2. Call the CRYS_RND_GenerateVector to generate a random second random value
 * 3. Compare the random numbers and verify the are different                                               
 *
 **************************/                                
CRYSError_t CRYS_ATP_TST_RND_Acceptance_Reset ( void )

{

    /*** TST Variables Definitions ****/
    TST_RND_TestDataStruct  TST_RND_Results = {{0},{0}};    
    DxUint16_t                 TST_RNDSize;
    CRYSError_t             TST_Status=0;
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RND_Acceptance_Reset";

    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ATP_TST_RND_Acceptance_Reset Tests          ******** \n"));       
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_RNDSize = 14 ; TST_RNDSize < TST_MAX_DATA_VEC_SIZE_IN_BYTS/2  ; TST_RNDSize=TST_RNDSize+17)
    {
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Random generation - Random Size = %ld \n", TST_RNDSize));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));

        /* Reset the random seed */
        /*-----------------------*/
        TST_Status = CRYS_RND_ResetSeed();
        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RND_ResetSeed","",TST_MasterTestName);
 
        
        /* Generate first random value */
        /*-----------------------------*/
        TST_ATP_StartPerformanceTimer(&TST_Timer);

        TST_Status = CRYS_RND_GenerateVector(TST_RNDSize,TST_RND_Results.TST_RND_Output1);

        TST_ATP_GetPerformanceTimer(&TST_Timer);
        TST_ATP_CalcPerformance(TST_RNDSize);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RND_GenerateVector","TST_RND_Output1",TST_MasterTestName);

        
        /* Reset the random seed */
        /*-----------------------*/
      TST_Status = CRYS_RND_ResetSeed();
        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RND_ResetSeed","",TST_MasterTestName);
 
 

        /* Generate Second random value */
        /*------------------------------*/      
        TST_ATP_StartPerformanceTimer(&TST_Timer);

        TST_Status = CRYS_RND_GenerateVector(TST_RNDSize,TST_RND_Results.TST_RND_Output2);

        TST_ATP_GetPerformanceTimer(&TST_Timer);
        TST_ATP_CalcPerformance(TST_RNDSize);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RND_GenerateVector","TST_RND_Output2",TST_MasterTestName);

        
        /* Compare the Random Values */
        /*---------------------------*/     
        TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_RND_Results.TST_RND_Output1,
                                                TST_RND_Results.TST_RND_Output2 ,
                                                TST_RNDSize);
                               
        ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                    "\nTST_RND_Output1--\n",
                                    TST_RND_Results.TST_RND_Output1,
                                    TST_RNDSize);
                                    
        ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                    "\nTST_RND_Output2--\n",
                                    TST_RND_Results.TST_RND_Output2,
                                    TST_RNDSize);                                                                      


        if (TST_Status == TESTPASS)
        {
        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n","TST_RND_Output1+2"));           
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - %s failed\n","DX_VOS_MemCmp"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - Wrong Error returned!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_Error - Error returned  --- %lX \n" ,TST_Status ));               
            return TESTFAIL;
        }
        else
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"TST_massage - "));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"%s","DX_VOS_MemCmp"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Error returned correctly - Test pass \n"));                              
        }
 

    } /* End of TST_RNDSize loop*/
  return TST_PASS;
   
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}/*End of test*/

#ifdef RND_KAT_TEST_MODE_FOR_VER_21
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_PRNG_Acceptance_Instantiation        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
The test are based on the tests specifications,
described in the Random Number Generator System Specification Revision 2.1.
To run these tests the project should be compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.

Notes: There are two global variables that contain entropy values that are used in PRNG functions,
only if these functions are compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.
The responsibility of the ATP test is to define these global variables and
to initialize them with requested by test specification values.

The instantiation function initializes the RNG.
This function should be called before any other PRNG operation.
                 
                                
 * Algorithm:       
1.	Initialize global first entropy (GlobalFirstEntropy) with test vector value  TST_FirstEntropy
2.	Initialize global entropy (GlobalEntropy) with test vector value TST_Entropy
3.	Call CRYS_RND_AddAdditionalInput with additional input test vector TST_AdditionalInput1 with size 16 bytes
4.	Call CRYS_RND_Instantiation function
5.	Call CRYS_RND_GenerateVector with size 112
6.	Compare output result with expected result TST_ExpResult1
7.	Call CRYS_RND_AddAdditionalInput with additional input test vector TST_AdditionalInput2 with size 16 bytes
9.	Call CRYS_RND_GenerateVector with size 8 bytes 
9.	Compare output result with expected result TST_ExpResult2
 **************************/   
CRYSError_t CRYS_ATP_TST_PRNG_Acceptance_Instantiation  ( void )
{
  CRYSError_t             TST_Status=0;
  char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RND_Instantiation";
  TST_PRNGInstantiation_TestDataStruct * TestDataStruct = &TST_PRNGInstantiation_Acceptance_TestData[0];
  DxUint8_t               OutputData[128];

  /*1.Initialize global first entropy (GlobalFirstEntropy) with test vector value  TST_FirstEntropy */
  /*********************************************************************************/
  DX_VOS_FastMemCpy((DxUint8_t*)GlobalFirstEntropy ,TestDataStruct->TST_FirstEntropy ,sizeof(TestDataStruct->TST_FirstEntropy));

  /*2. Initialize global entropy (GlobalEntropy) with test vector value TST_Entropy*/
  /*********************************************************************************/
  DX_VOS_FastMemCpy((DxUint8_t*)GlobalEntropy ,TestDataStruct->TST_Entropy ,sizeof(TestDataStruct->TST_Entropy));

  /*3.Call CRYS_RND_AddAdditionalInput with additional input test vector TST_AdditionalInput1 with size 16 bytes*/
  /*********************************************************************************/
  TST_Status = CRYS_RND_AddAdditionalInput(TestDataStruct->TST_AdditionalInput1 ,sizeof(TestDataStruct->TST_AdditionalInput1));

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Add Additional Input","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*4. Call CRYS_RND_Instantiation function*/
  /*********************************************************************************/
  TST_Status = CRYS_RND_Instantiation();

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Instantiation","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*5.Call CRYS_RND_GenerateVector with size 112*/
  /*********************************************************************************/
  TST_Status = CRYS_RND_GenerateVector(112 ,OutputData);

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_GenerateVector","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*6. Compare output result with expected result TST_ExpResult1*/
  /*********************************************************************************/
  TST_Status = DX_VOS_MemCmp(OutputData , TestDataStruct->TST_ExpResult1 , sizeof(TestDataStruct->TST_ExpResult1));
  if(TST_Status == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"Instatiation PRNG ATP test step 1 - pass\n"));
  }
  else
  {
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                              "DX_VOS_MemCmp","CRYS_ATP_TST_RND_Instantiation",
                              TST_MasterTestName);
  }

  /*7. Call CRYS_RND_AddAdditionalInput with additional input test vector TST_AdditionalInput2 with size 16 bytes*/
  /*********************************************************************************/
  TST_Status = CRYS_RND_AddAdditionalInput(TestDataStruct->TST_AdditionalInput2 ,sizeof(TestDataStruct->TST_AdditionalInput2));

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Add Additional Input","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*8. Call CRYS_RND_GenerateVector with size 8 bytes*/
  /*********************************************************************************/
  TST_Status = CRYS_RND_GenerateVector(8 ,OutputData);

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_GenerateVector","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*9. Compare output result with expected result TST_ExpResult2*/
  /*********************************************************************************/
  TST_Status = DX_VOS_MemCmp(OutputData , TestDataStruct->TST_ExpResult2 , sizeof(TestDataStruct->TST_ExpResult2));
  if(TST_Status == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"Instatiation PRNG ATP test step 2 - pass"));
  }
  else
  {
     TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                "DX_VOS_MemCmp","CRYS_ATP_TST_RND_Instantiation",
                                TST_MasterTestName);
  }

return TST_PASS;
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_PRNG_Acceptance_ReSeeding        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
The test are based on the tests specifications,
described in the Random Number Generator System Specification Revision 2.1.
To run these tests the project should be compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.

Notes: There are two global variables that contain entropy values that are used in PRNG functions,
only if these functions are compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.
The responsibility of the ATP test is to define these global variables and
to initialize them with requested by test specification values.

Reseeding provides mixing of additional entropy into the working state.


 *                                  
 * Algorithm:       
1.	Initialize global first entropy (GlobalFirstEntropy) with test vector value  TST_FirstEntropy
2.	Initialize global entropy (GlobalEntropy) with test vector value TST_Entropy
3.	Call function CRYS_RND_Instantiation
4.	Initialize global entropy (GlobalEntropy) with test vector value TST_ReSeedingEntropy1
5.	Call CRYS_RND_Reseeding function
6.	Call CRYS_RND_GenerateVector with size 8
7.	Compare output result with expected output TST_ExpResult1
8.	Initialize global entropy with test vector TST_ReSeedingEntropy2
9.	Call CRYS_RND_AddAdditionalInput with additional input test vector  TST_ReSeedingAddInput 
10.	Call CRYS_RND_Reseeding function
11.	Call CRYS_RND_GenerateVector with size 8 bytes 
12.	Compare output result with expected result TST_ExpResult2                                   
 *
 **************************/  
CRYSError_t CRYS_ATP_TST_PRNG_Acceptance_ReSeeding  ( void )
{
  CRYSError_t             TST_Status=0;
  char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_PRNG_Acceptance_ReSeeding";
  TST_PRNGReSeeding_TestDataStruct TestDataStruct = TST_PRNGReSeeding_Acceptance_TestData[0];
  DxUint8_t               OutputData[128];

  /*1 .Initialize global first entropy (GlobalFirstEntropy) with test vector value  TST_FirstEntropy*/
	/**************************************************************************************************/
  DX_VOS_FastMemCpy((DxUint8_t*)GlobalFirstEntropy ,TestDataStruct.TST_FirstEntropy ,sizeof(TestDataStruct.TST_FirstEntropy));

  /*2.Initialize global entropy (GlobalEntropy) with test vector value TST_Entropy */
	/**************************************************************************************************/
  DX_VOS_FastMemCpy((DxUint8_t*)GlobalEntropy ,TestDataStruct.TST_Entropy ,sizeof(TestDataStruct.TST_Entropy));

  /*3.Call function CRYS_RND_Instantiation*/
  /**************************************************************************************************/
  TST_Status = CRYS_RND_Instantiation();

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Instantiation","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);
  
  /*4.Initialize global entropy (GlobalEntropy) with test vector value TST_ReSeedingEntropy1*/
  /**************************************************************************************************/
  DX_VOS_FastMemCpy((DxUint8_t*)GlobalEntropy ,TestDataStruct.TST_ReSeedingEntropy1 ,sizeof(TestDataStruct.TST_ReSeedingEntropy1));

  /*5.Call CRYS_RND_Reseeding function*/
  /**************************************************************************************************/
  TST_Status = CRYS_RND_Reseeding();

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Reseeding","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*6. Call CRYS_RND_GenerateVector with size 8*/
  /**************************************************************************************************/
  TST_Status = CRYS_RND_GenerateVector(8 ,OutputData);

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Generate Vector","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*7. Compare output result with expected output TST_ExpResult1*/
	/**************************************************************************************************/
  TST_Status = DX_VOS_MemCmp(OutputData , TestDataStruct.TST_ExpResult1 , sizeof(TestDataStruct.TST_ExpResult1));
  if(TST_Status == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"Reseeding PRNG ATP test step 1 - pass\n"));
  }
  else
  {
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                              "DX_VOS_MemCmp","CRYS_ATP_TST_RND_Instantiation",
                              TST_MasterTestName);
  }

  /*8. Initialize global entropy with test vector TST_ReSeedingEntropy2*/
  /***************************************************************************************************/
  DX_VOS_FastMemCpy((DxUint8_t*)GlobalEntropy ,TestDataStruct.TST_ReSeedingEntropy2 ,sizeof(TestDataStruct.TST_ReSeedingEntropy2));

  /*9 .Call CRYS_RND_AddAdditionalInput with additional input test vector  TST_ReSeedingAddInput*/
	/**************************************************************************************************/
  TST_Status = CRYS_RND_AddAdditionalInput(TestDataStruct.TST_ReSeedingAddInput ,sizeof(TestDataStruct.TST_ReSeedingAddInput));
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Add Additional Input","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*10. Call CRYS_RND_Reseeding function*/
	/**************************************************************************************************/
  TST_Status = CRYS_RND_Reseeding();
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_Reseeding","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*11. Call CRYS_RND_GenerateVector with size 8 bytes*/
	/**************************************************************************************************/
  TST_Status = CRYS_RND_GenerateVector(8 ,OutputData);
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                            "CRYS_RND_GenerateVector","CRYS_ATP_TST_RND_Instantiation",
                            TST_MasterTestName);

  /*12 .Compare output result with expected result TST_ExpResult2*/
	/**************************************************************************************************/
  TST_Status = DX_VOS_MemCmp(OutputData , TestDataStruct.TST_ExpResult2 , sizeof(TestDataStruct.TST_ExpResult2));
  if(TST_Status == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"Reseeding PRNG ATP test step 2 - pass"));
  }
  else
  {
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                              "DX_VOS_MemCmp","CRYS_ATP_TST_RND_Instantiation",
                              TST_MasterTestName);
  }

return TST_PASS;
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}
#endif /* #ifdef RND_KAT_TEST_MODE_FOR_VER_21 */


#endif


